/*----------------------------------------------------------------------------
 * Name:    LCM.h
 * Purpose: LCM definitions
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/

#ifndef __LCM_H
#define __LCM_H

#include "ht32.h"

// <<< Use Configuration Wizard in Context Menu >>>

#define	LCM_GPIO_MODE				0
#define	LCM_SPI_MODE				1

//	<h> LCM Interface Configuration
//		<o _GPIO_SPI_> Interface Configuration
//    	<LCM_GPIO_MODE=> GPIO
//       <LCM_SPI_MODE=>  SPI
#define _GPIO_SPI_  					(LCM_GPIO_MODE)
//	</h>

#define	LCM_NCS_PORT				HT_GPIOB
#define  LCM_NCS   					GPIO_PIN_2					/*PB2*/
#define	LCM_NCS_AFIO_PORT			GPIO_PB
#if	(_GPIO_SPI_ == LCM_GPIO_MODE)
#define	LCM_NCS_AFIO_FUN			AFIO_FUN_GPIO
#else
#define	LCM_NCS_AFIO_FUN			AFIO_FUN_SPI
#endif

#define	LCM_SCK_PORT				HT_GPIOB
#define  LCM_SCK   					GPIO_PIN_3					/*PB3*/
#define	LCM_SCK_AFIO_PORT			GPIO_PB
#if	(_GPIO_SPI_ == LCM_GPIO_MODE)
#define	LCM_SCK_AFIO_FUN			AFIO_FUN_GPIO
#else
#define	LCM_SCK_AFIO_FUN			AFIO_FUN_SPI
#endif

#define	LCM_SDA_PORT				HT_GPIOB
#define  LCM_SDA   					GPIO_PIN_4					/*PB4*/
#define	LCM_SDA_AFIO_PORT			GPIO_PB
#if	(_GPIO_SPI_ == LCM_GPIO_MODE)
#define	LCM_SDA_AFIO_FUN			AFIO_FUN_GPIO
#else
#define	LCM_SCK_AFIO_FUN			AFIO_FUN_SPI
#endif

#define	LCM_RS_PORT					HT_GPIOB
#define  LCM_RS    					GPIO_PIN_5					/*PB5*/
#define	LCM_RS_AFIO_PORT			GPIO_PB
#define	LCM_RS_AFIO_FUN			AFIO_FUN_GPIO

#define	LCM_RES_PORT				HT_GPIOB
#define  LCM_RES   					GPIO_PIN_7					/*PB7*/
#define	LCM_RES_AFIO_PORT			GPIO_PB
#define	LCM_RES_AFIO_FUN			AFIO_FUN_GPIO

#define	LCM_RES_SET()				(LCM_RES_PORT->SRR=LCM_RES)
#define	LCM_RES_RESET()			(LCM_RES_PORT->RR=LCM_RES)
#define	LCM_RS_DATA()				(LCM_RS_PORT->SRR=LCM_RS)
#define	LCM_RS_COMD()				(LCM_RS_PORT->RR=LCM_RS)

#if	(_GPIO_SPI_ == LCM_GPIO_MODE)
#define	LCM_NCS_SET()				(LCM_NCS_PORT->SRR=LCM_NCS)
#define	LCM_NCS_RESET()			(LCM_NCS_PORT->RR=LCM_NCS)
#define	LCM_SCK_SET()				(LCM_SCK_PORT->SRR=LCM_SCK)
#define	LCM_SCK_RESET()			(LCM_SCK_PORT->RR=LCM_SCK)
#define	LCM_SDA_SET()				(LCM_SDA_PORT->SRR=LCM_SDA)
#define	LCM_SDA_RESET()			(LCM_SDA_PORT->RR=LCM_SDA)
#else
#define  LCM_SPI     				HT_SPI0
#define	LCM_SPI_PCLK				CKCU_PCLK_SPI0
#define	LCM_SPI_SPEED				(5000000UL)
#endif

enum 
{
	LCM_FONT6X8 = 0x01,
	LCM_FONT8X8,
	LCM_FONT8X16
};

enum 
{
   DSP_NORMAL = 0x50,
   DSP_INVERT,
   DSP_CURSOR,
   DSP_CLEAR	
};

extern uc8 BestComm_Logo[];

void lcm_bus_configure(void);
void lcm_configure(void);
void lcm_write_cmd(u8 cmdx);
void lcm_write_data(u8 da);
void lcm_set_position(u8 row,u8 col);
void lcm_write_blcok_data(u8 leng,u8 *p,u8 invt);
void lcm_clear(void);
void lcm_put_map(u8 *p);
void lcm_printf(u8 row,u8 col,u8 invt,u8 font,const char *format,...);
void lcm_put6x8_char(char val,u8 row,u8 col,u8 invt);
void lcm_put8x8_char(char val,u8 row,u8 col,u8 invt);
void lcm_put8x16_char(char val,u8 row,u8 col,u8 invt);
void lcm_put6x8_clearing(u8 row);
void lcm_put6x8_string(sc8 *p,u8 row,u8 col,u8 invt);
void lcm_put8x8_clearing(u8 row);
void lcm_put8x8_string(sc8 *p,u8 row,u8 col,u8 invt);
void lcm_put8x16_clearing(u8 row);
void lcm_put8x16_string(sc8 *p,u8 row,u8 col,u8 invt);

#endif
